#include "ODEFixedJoint.h"

namespace PhysicsEngine
{

ODEFixedJoint::ODEFixedJoint()
{
}

ODEFixedJoint::ODEFixedJoint(dWorldID world, int objectid, IPhysicalBody *body1, IPhysicalBody *body2): IPhysicalFixedJoint(objectid, body1, body2), ODEJoint(world)
{
	dGeomID idbody1=0;
	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body1))
	{
		idbody1 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body1))
	{
		idbody1 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body1))
	{
		idbody1 = odesphere->GetGeomId();
	}
	dGeomID idbody2=0;
	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body2))
	{
		idbody2 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body2))
	{
		idbody2 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body2))
	{
		idbody2 = odesphere->GetGeomId();
		}
	dJointID jointId;
	jointId = dJointCreateFixed (world,0);
	dJointAttach (jointId,dGeomGetBody(idbody1),dGeomGetBody(idbody2));
	dJointSetFixed (jointId);
	this->SetJointId(jointId);
}

ODEFixedJoint::~ODEFixedJoint()
{
}

dJointID ODEFixedJoint::GetJointId()
{
	return jointid;
}

void ODEFixedJoint::SetJointId(dJointID id)
{
	this->jointid = id;
}
DataFixedJoint *ODEFixedJoint::GetDataFixedJoint()
{
	return new DataFixedJoint(this->GetObjectId(),this->GetBody1()->GetObjectId(),this->GetBody2()->GetObjectId());
}

void ODEFixedJoint::UpdateData()
{
	
}

}
